#ifndef __MWERKS__
#include <Desk.h>
#include <Dialogs.h>
#include <Errors.h>
#include <Files.h>
#include <Fonts.h>
#include <Memory.h>
#include <Menus.h>
#include <StandardFile.h>
#include <TextEdit.h>
#include <Types.h>
#include <Windows.h>
#endif

#include "HTUtils.h"

#include "MacGlobals.h"
//#include "DSUserProcs.h"
#include "MacAppleEvents.h"

#include "MacCore.h"
#include "v_maccur.h"

Boolean		gDone, gOApped, gHasAppleEvents, gWasEvent;
EventRecord	gEvent;
MenuHandle	gAppleMenu, gFileMenu;
WindowPtr	gSplashScreen;



void InitToolbox (void) 
{
	InitGraf ( &qd.thePort );
	InitFonts ();
	InitWindows ();
	InitMenus ();
	TEInit ();
	InitDialogs (NULL);		
	InitCursor ();
	FlushEvents ( everyEvent, 0 );
	SetApplLimit(GetApplLimit()-65536);
	MoreMasters ();
}

Boolean InitGlobals (void) 
{
	long aLong;

	gDone			= false;
	gOApped			= false;	// probably not since users are supposed to DROP things!
	gHasAppleEvents	= Gestalt ( gestaltAppleEventsAttr, &aLong ) == noErr;
	gSplashScreen	= NULL;
	return 1;
}

/*
	Again, nothing fancy.  Just setting up the menus.
*/
void SetUpMenus (void) 
{
	gAppleMenu = GetMenu ( kAppleNum );
	AppendResMenu ( gAppleMenu, 'DRVR' );
	InsertMenu ( gAppleMenu, 0 );

	gFileMenu = GetMenu ( kFileNum );
	InsertMenu ( gFileMenu, 0 );
	DrawMenuBar ();
}

/*
	This routine is called during startup to display a splash screen.
	
	This was recommend by the Blue Team HI person, John Sullivan, who
	feels that all apps should display something so that users can easily
	tell what is running, and be able to switch by clicking.  Thanks John!
*/
void InstallSplashScreen(void) 
{
	#define windowPicID	128

	PicHandle	picH;

	if (!gSplashScreen) {  // show the splash screen window
		picH = GetPicture(windowPicID);
		if (picH) {
			gSplashScreen = GetNewWindow(windowPicID, NULL, (WindowPtr)-1L);
			if (gSplashScreen) {
				SetWindowPic(gSplashScreen, picH);
				// Don't show it here, since we only want to it for oapp launches!
				ShowWindow(gSplashScreen);
			}
		}
	}
}


/*	--------------- Standard Event Handling routines ---------------------- */
void ShowAbout () 
{
	DialogPtr about;
	short ih;

	about = GetNewDialog(1000, NULL,(void *)-1);
	DrawDialog(about);
	ModalDialog(NULL,&ih);
	DisposeDialog(about);
}


void DoMenu(long select)
{
	short		theMenuID, theItem, theFontNumber, result;
	MenuHandle	theMenu;
	Str255		theName;
	WindowPtr	theWindow;
	Point		where;

//	theDocument = IsDocumentWindow(theWindow = FrontWindow());

	theItem   = LoWord(select);
	theMenuID = HiWord(select);
	theMenu   = GetMenuHandle(theMenuID);
	switch(theMenuID) {
		case kAppleNum:
			if ( theItem == 1 )
				ShowAbout ();	/*	Show the about box */
			else
			{
				GetMenuItemText(GetMenuHandle(kAppleNum), theItem, theName);
				OpenDeskAcc(theName);
			}
			break;
		case kFileNum:
			MacClose();
			break;
/*		case idEditMenu:
			switch(theItem) {
				case iUndo:
					DoUndoDrag();
					break;
				case iCut:
					if (theDocument) {
						DisableUndoDrag();
						TEICut(theDocument->theTE);
					}
					break;
				case iCopy:
					if (theDocument) {
						TECopy(theDocument->theTE);
					}
					break;
				case iPaste:
					if (theDocument) {
						if (!DoSpecialPaste(theDocument)) {
							DisableUndoDrag();
							TEIPaste(theDocument->theTE, 0L, 0L);
						}
					}
					break;
				case iClear:
					if (theDocument) {
						DisableUndoDrag();
						TEDelete(theDocument->theTE);
					}
					break;
				case iSelectAll:
					if (theDocument)
						DoSelectAllDocument(theDocument);
					break;
			}
			break;
		case idFontMenu:
			DisableUndoDrag();
			GetItem(GetMHandle(idFontMenu), theItem, theName);
			GetFNum(theName, &theFontNumber);
			DoFontSelection(theFontNumber);
			break;
		case idSizeMenu:
			DisableUndoDrag();
			DoSizeSelection(ItemToSize(theItem));
			break;
		case idStyleMenu:
			DisableUndoDrag();
			DoStyleSelection(theItem);
			break;
*/	}

//	if (theDocument = IsDocumentWindow(FrontWindow()))
//		TEGetHiliteRgn(theDocument->hiliteRgn, theDocument->theTE);

	HiliteMenu(0);
}


void DoMenuC ( long retVal ) 
{
	short	menuID, itemID;
	Str255	itemStr;

	menuID = HiWord ( retVal );
	itemID = LoWord ( retVal );
	
	switch ( menuID ) {
		case kAppleNum:
			if ( itemID == 1 )
				ShowAbout ();	/*	Show the about box */
			else
			{
				GetMenuItemText(GetMenuHandle(kAppleNum), itemID, itemStr);
				OpenDeskAcc(itemStr);
			}
			break;
			
		case kFileNum:
//			if ( itemID == 1 )
//				SelectFile();		// call file selection userProc
//			else
				MacClose();
			break;
		
		default:
			break;
			
		}
	HiliteMenu(0);		// turn it off!
}


pascal void DoContent ( WindowPtr theWindow, EventRecord *theEvent )
{
	short			cntlCode;
	short			part;
	short			value;
	ControlHandle	theControl;
	GrafPtr			savePort;
	Boolean			extend;
	Point			localPt;
	
	
    GetPort ( &savePort );
    SetPort ( theWindow );
 	
	localPt = theEvent->where;
    GlobalToLocal ( &localPt );

	maccur_mouse_content(localPt);
 
	SetPort(savePort);
}


pascal void DoZoom(WindowPtr w,
                   short     c,
                   Point     p)

 {
   GrafPtr savePort;

	 GetPort(&savePort);
   SetPort(w);
	 if (TrackBox(w, p, c))
		 {
			 EraseRect(&w->portRect);
			 IssueZoomCommand(w, c);
		 }
}
void	IssueSizeWindow(short newHSize, short newVSize)
{
	maccur_resize(newHSize,newVSize);
}

#define	kScrollbarSize	15

pascal void MyGrowWindow(WindowPtr w, Point p)
	{
		GrafPtr savePort;
    long    theResult;
    Rect    r;
	short a,b;

    GetPort(&savePort);
    SetPort(w);
    SetRect(&r, 80, 80, qd.screenBits.bounds.right, qd.screenBits.bounds.bottom);
    theResult = GrowWindow(w, p, &r);
		if (theResult)
		{
			a=LoWord(theResult);
			b=HiWord(theResult);
			maccur_resize(a-kScrollbarSize,b-kScrollbarSize);
		}
    SetPort(savePort);
	maccur_update(w);
	}

void DoMouseDown ( EventRecord *curEvent ) 
{
	WindowPtr	whichWindow;
	short		whichPart;

	whichPart = FindWindow ( curEvent->where, &whichWindow );
	switch ( whichPart ) {
		case inMenuBar:
			DoMenu ( MenuSelect ( curEvent->where ));
			break;
		
		case inSysWindow:
			SystemClick ( curEvent, whichWindow );
			break;
		
		case inDrag:
			{
				Rect	boundsRect = (*GetGrayRgn())->rgnBBox;
				DragWindow ( whichWindow, curEvent->where, &boundsRect );
				break;
			}
		case inContent: 
				DoContent(whichWindow, curEvent);
                break;

		case inGrow:SetCursor(&qd.arrow);
	//			if (Ours(whichWindow))
					MyGrowWindow(whichWindow, curEvent->where);
				break;

		default:
			break;
		}
	}


void DoKeyDow1n ( EventRecord *curEvent ) 
{
	if ( curEvent->modifiers & cmdKey )
		DoMenu ( MenuKey ((char) curEvent->message & charCodeMask ));
}

/*
 *	DoKeyDown is called to handle keyDown or autoKey events.
 */

void DoKeyDown(EventRecord *theEvent)
{	char		theChar;

	theChar = theEvent->message & charCodeMask;

	if (theEvent->modifiers & cmdKey) 
	{
		DoMenu (MenuKey(theChar));
	}
}


int KeyPressed()
{
	EventRecord event;
	return (EventAvail(keyDownMask,&event));
}


void DoOneEvent()
{
	EventRecord event;
	if (!KeyPressed())
		if (WaitNextEvent(everyEvent, &event, 0, nil))
			DoEvent(&event);
}


void DoEvent ( EventRecord *event )
{
	int i;

	switch (event->what)
	{
		case kHighLevelEvent:
			AEProcessAppleEvent(event);
			break;

		case mouseDown:
			DoMouseDown(event);
			break;

		case updateEvt:
			maccur_update((WindowPtr)(event->message));
			break;

		case osEvt:												/* Switch background/foreground. */
			if ((event->message & suspendResumeMessage) == resumeFlag)
				in_background_flag = FALSE;
			else
			{
				in_background_flag = TRUE;
				maccur_unflash_cursor();						/* Turn cursor off in the background. */
			}
			break;

	}
}


void MacMain ( ) 
{
	InitToolbox ();
	if ( InitGlobals () ) 
	{	// if we succeeding in initting self
		if ( !gHasAppleEvents )
		{
			if (TRACE)
				printf("Cannot initialize AppleEvents");//ErrorAlert ( kErrStringID, kCantRunErr, 0 );
		}
		else 
		{
			InitAEVTStuff ();
			SetUpMenus ();
//			InstallSplashScreen ();
			
/*			while ( !gDone ) {
				gWasEvent = WaitNextEvent ( everyEvent, &gEvent, 0, NULL );
				if ( gWasEvent ) {
					switch ( gEvent.what ) {
						case kHighLevelEvent:
							DoHighLevelEvent ( &gEvent );
							break;
							
						case mouseDown:
							DoMouseDown ( &gEvent );
							break;
							
						case keyDown:
						case autoKey:
							DoKeyDown ( &gEvent );
							break;

						case diskEvt:
							if (HiWord(gEvent.message)) {
								Point diskInitPt;
								
								diskInitPt.v = diskInitPt.h = 100;
								DILoad();
								DIBadMount(diskInitPt, gEvent.message);
								DIUnload();
							}
							break;
							
						default:
							break;
					}
				}
			}*/
		}
//		DisposeUserGlobals();	// call the userproc to clean itself up
	}
}
